<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EventClosure extends Model 
{

    protected $table = 'event_closure';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('description', 'closure_date', 'event_id', 'equipment_id', 'due_date', 'status');

    public function event()
    {
        return $this->belongsTo('Event', 'event_id');
    }

    public function equipment()
    {
        return $this->belongsTo('Equipment', 'equipment_id');
    }

}