<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InstantClosure extends Model 
{

    protected $table = 'instant_closure';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('description', 'due_date', 'responsible_id', 'closure_date', 'incident_id', 'type', 'status');

    public function responsible()
    {
        return $this->belongsTo('Engineer', 'responsible_id');
    }

    public function incident()
    {
        return $this->belongsTo('Incident', 'incident_id');
    }

}