<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ptw extends Model 
{

    protected $table = 'ptw';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'project_id', 'ptw_type_id', 'time', 'ptw_location', 'company', 'note');

    public function ptw_type()
    {
        return $this->belongsTo('PtwType', 'ptw_type_id');
    }

}