<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCauseTable extends Migration {

	public function up()
	{
		Schema::create('cause', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('description')->nullable();
			$table->enum('type', array('root_cause', 'direct_cause'))->nullable();
			$table->integer('incident_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cause');
	}
}