<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MaintenanceLog extends Eloquent {

	protected $table = 'maintenance_log';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('equipment_id', 'project_id', 'task', 'performer', 'note', 'date');

	public function equipment()
	{
		return $this->belongsTo('Equipment', 'equipment_id');
	}

	public function project_id()
	{
		return $this->belongsTo('Project', 'project_id');
	}

}