<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('inspeccion', function(Blueprint $table) {
			$table->foreign('derivacion_id')->references('id')->on('derivacion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('derivacion', function(Blueprint $table) {
			$table->foreign('carpeta_id')->references('id')->on('carpeta')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('derivacion', function(Blueprint $table) {
			$table->foreign('inspeccion_id')->references('id')->on('inspeccion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carpeta', function(Blueprint $table) {
			$table->foreign('profesional_id')->references('id')->on('profesional')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carpeta_propietario', function(Blueprint $table) {
			$table->foreign('carpeta_id')->references('id')->on('carpeta')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carpeta_propietario', function(Blueprint $table) {
			$table->foreign('propietario_id')->references('id')->on('propietario')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parcela_hist', function(Blueprint $table) {
			$table->foreign('carpeta_id')->references('id')->on('carpeta')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inspeccion_inspector', function(Blueprint $table) {
			$table->foreign('inspeccion_id')->references('id')->on('inspeccion')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inspeccion_inspector', function(Blueprint $table) {
			$table->foreign('inspector_id')->references('id')->on('inspector')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carpeta_estado', function(Blueprint $table) {
			$table->foreign('estado_id')->references('id')->on('estado')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carpeta_estado', function(Blueprint $table) {
			$table->foreign('carpeta_id')->references('id')->on('carpeta')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('inspeccion', function(Blueprint $table) {
			$table->dropForeign('inspeccion_derivacion_id_foreign');
		});
		Schema::table('derivacion', function(Blueprint $table) {
			$table->dropForeign('derivacion_carpeta_id_foreign');
		});
		Schema::table('derivacion', function(Blueprint $table) {
			$table->dropForeign('derivacion_inspeccion_id_foreign');
		});
		Schema::table('carpeta', function(Blueprint $table) {
			$table->dropForeign('carpeta_profesional_id_foreign');
		});
		Schema::table('carpeta_propietario', function(Blueprint $table) {
			$table->dropForeign('carpeta_propietario_carpeta_id_foreign');
		});
		Schema::table('carpeta_propietario', function(Blueprint $table) {
			$table->dropForeign('carpeta_propietario_propietario_id_foreign');
		});
		Schema::table('parcela_hist', function(Blueprint $table) {
			$table->dropForeign('parcela_hist_carpeta_id_foreign');
		});
		Schema::table('inspeccion_inspector', function(Blueprint $table) {
			$table->dropForeign('inspeccion_inspector_inspeccion_id_foreign');
		});
		Schema::table('inspeccion_inspector', function(Blueprint $table) {
			$table->dropForeign('inspeccion_inspector_inspector_id_foreign');
		});
		Schema::table('carpeta_estado', function(Blueprint $table) {
			$table->dropForeign('carpeta_estado_estado_id_foreign');
		});
		Schema::table('carpeta_estado', function(Blueprint $table) {
			$table->dropForeign('carpeta_estado_carpeta_id_foreign');
		});
	}
}