<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Carpeta extends Eloquent {

	protected $table = 'carpeta';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function propietario()
	{
		return $this->belongsTo('App\Moron\Models\Carpeta_propietario', 'inmueble_id');
	}

	public function derivaciones()
	{
		return $this->hasMany('App\Moron\Models\Derivacion', 'derivacion_id');
	}

	public function estados()
	{
		return $this->hasMany('App\Moron\Models\CarpetaEstado', 'carpeta_id');
	}

	public function profesionales()
	{
		return $this->hasMany('App\Moron\Models\Profesional', 'profesional_id');
	}

}