<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehouseTable extends Migration {

	public function up()
	{
		Schema::create('warehouse', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('contact_name')->nullable();
			$table->string('contact_no')->nullable();
			$table->text('address')->nullable();
			$table->string('lat')->nullable();
			$table->string('long')->nullable();
			$table->text('description')->nullable();
			$table->boolean('active')->default(1);
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('warehouse');
	}
}