<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_id');
			$table->integer('entity_type');
			$table->smallInteger('type');
			$table->text('file_path');
			$table->bigInteger('quantity')->nullable();
			$table->double('amount');
			$table->tinyInteger('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}