<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripDropOutsTable extends Migration {

	public function up()
	{
		Schema::create('trip_drop_outs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('trip_id')->unsigned()->nullable();
			$table->string('time')->nullable();
			$table->enum('type', array('paid', 'free'))->nullable();
			$table->string('discount_price')->nullable();
			$table->string('captain_wallet')->nullable();
			$table->string('client_wallet')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('trip_drop_outs');
	}
}