<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('rated_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('vehicle_id')->references('id')->on('vehicles')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classes_countries', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('vehicle_classes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('classes_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('vehicle_classes')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('mark_id')->references('id')->on('car_marks')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('model_years', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('car_models')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('mark_id')->references('id')->on('car_marks')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('car_models')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('vehicle_classes')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('captain_images', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('captain_images', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('payment_charges', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('user_credites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('captain_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('vehicle_classes')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('trip_drop_outs', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('user_credites')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('trip_histories', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trip_histories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('from_user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('to_user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('set null')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('tokens', function(Blueprint $table) {
			$table->dropForeign('tokens_user_id_foreign');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->dropForeign('banks_country_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_rated_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_vehicle_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_user_id_foreign');
		});
		Schema::table('classes_countries', function(Blueprint $table) {
			$table->dropForeign('classes_countries_class_id_foreign');
		});
		Schema::table('classes_countries', function(Blueprint $table) {
			$table->dropForeign('classes_countries_country_id_foreign');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_class_id_foreign');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_mark_id_foreign');
		});
		Schema::table('model_years', function(Blueprint $table) {
			$table->dropForeign('model_years_model_id_foreign');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->dropForeign('complaints_user_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_user_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_mark_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_model_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_class_id_foreign');
		});
		Schema::table('captain_images', function(Blueprint $table) {
			$table->dropForeign('captain_images_user_id_foreign');
		});
		Schema::table('captain_images', function(Blueprint $table) {
			$table->dropForeign('captain_images_bank_id_foreign');
		});
		Schema::table('payment_charges', function(Blueprint $table) {
			$table->dropForeign('payment_charges_user_id_foreign');
		});
		Schema::table('user_credites', function(Blueprint $table) {
			$table->dropForeign('user_credites_user_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_client_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_captain_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_class_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_coupon_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_country_id_foreign');
		});
		Schema::table('trip_drop_outs', function(Blueprint $table) {
			$table->dropForeign('trip_drop_outs_trip_id_foreign');
		});
		Schema::table('trip_histories', function(Blueprint $table) {
			$table->dropForeign('trip_histories_trip_id_foreign');
		});
		Schema::table('trip_histories', function(Blueprint $table) {
			$table->dropForeign('trip_histories_user_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_from_user_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_to_user_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_trip_id_foreign');
		});
	}
}