<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('institute_id')->unsigned()->index();
			$table->string('student_name', 191)->nullable();
			$table->string('student_photo', 191)->nullable();
			$table->string('student_parents', 191)->nullable();
			$table->string('student_class', 191)->nullable();
			$table->string('student_section', 191)->nullable();
			$table->string('student_batch', 191)->nullable();
			$table->integer('roll_no')->nullable();
			$table->integer('registration_no')->nullable();
			$table->date('student_date_of_birth')->nullable();
			$table->string('student_blood_group', 191)->nullable();
			$table->string('student_contact', 191)->nullable();
			$table->string('student_department', 191)->nullable();
			$table->string('student_signature', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}