<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('institute_id')->unsigned()->index();
			$table->string('teacher_name', 191)->nullable();
			$table->string('teacher_photo', 191)->nullable();
			$table->integer('employee_code')->nullable();
			$table->string('teacher_blood_group', 191)->nullable();
			$table->date('teacher_date_of_birth')->nullable();
			$table->string('teacher_contact', 191)->nullable();
			$table->string('teacher_department', 191)->nullable();
			$table->string('teacher_signature', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}