<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->foreign('FKDirectorio')->references('PKCodDirectorio')->on('tbldirectorio')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->foreign('FKResponsable')->references('PKCodFuncionario')->on('tblUsuario')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->foreign('FKEstadoDocumento')->references('PKCodEstado')->on('tblestado')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->foreign('FkAmbito')->references('PKCodArea')->on('tblGrupo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tblUsuario', function(Blueprint $table) {
			$table->foreign('FKArea')->references('PKCodArea')->on('tblGrupo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->dropForeign('tbldocumento_FKDirectorio_foreign');
		});
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->dropForeign('tbldocumento_FKResponsable_foreign');
		});
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->dropForeign('tbldocumento_FKEstadoDocumento_foreign');
		});
		Schema::table('tbldocumento', function(Blueprint $table) {
			$table->dropForeign('tbldocumento_FkAmbito_foreign');
		});
		Schema::table('tblUsuario', function(Blueprint $table) {
			$table->dropForeign('tblUsuario_FKArea_foreign');
		});
	}
}