<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDmImageBuildersTable extends Migration {

	public function up()
	{
		Schema::create('dm_image_builders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('image_name')->index();
			$table->integer('base_image_id')->unsigned()->index();
			$table->integer('campaign_id');
			$table->integer('segment_id')->index();
			$table->text('description');
			$table->longText('template');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('dm_image_builders');
	}
}