<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Partner extends Eloquent {

	protected $table = 'partners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'url', 'logo_image');

	public function coupons()
	{
		return $this->hasMany('Coupon');
	}

	public function importers()
	{
		return $this->hasMany('Importer');
	}

	public function paymentTypes()
	{
		return $this->hasMany('PaymentType');
	}

}