<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Review extends Eloquent {

	protected $table = 'reviews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('url', 'is_active', 'published_at');

	public function productVariant()
	{
		return $this->belongsTo('ProductVariant');
	}

}