<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('password');
	protected $fillable = array('email', 'first_name', 'last_name', 'nick_name', 'active', 'password_changed_at');
	protected $hidden = array('password');

	public function priceAlerts()
	{
		return $this->hasOne('PriceAlert');
	}

}