<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRelationsTable extends Migration {

	public function up()
	{
		Schema::create('relations', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('source', array('product', 'product_variant'));
			$table->integer('product_id');
			$table->integer('model_id');
			$table->string('model_type', 255);
			$table->string('group', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('relations');
	}
}