<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogsTable extends Migration {

	public function up()
	{
		Schema::create('logs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('login_id', 100);
			$table->string('ip_address', 100);
			$table->enum('channel', array('web', 'app', 'system'))->nullable();
			$table->enum('action', array('create', 'update', 'delete'))->nullable();
			$table->string('target_table', 100);
			$table->integer('target_id')->nullable();
			$table->string('description', 255)->nullable();
			$table->timestamp('created_at');
		});
	}

	public function down()
	{
		Schema::drop('logs');
	}
}