<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttendanceRecordsTable extends Migration {

	public function up()
	{
		Schema::create('attendance_records', function(Blueprint $table) {
			$table->integer('at_id')->unsigned();
			$table->integer('st_id')->unsigned();
			$table->date('rec_date');
			$table->enum('status', array('attend', 'late', 'absent'));
			$table->timestamps();
			$table->string('memo', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('attendance_records');
	}
}