<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('programId')->references('id')->on('programs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services_providers', function(Blueprint $table) {
			$table->foreign('serviceId')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services_providers', function(Blueprint $table) {
			$table->foreign('userId')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('customerId')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('serviceId')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('userId')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->foreign('scopeFileId')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_items', function(Blueprint $table) {
			$table->foreign('serviceId')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agreement_estimates', function(Blueprint $table) {
			$table->foreign('agreementId')->references('id')->on('agreements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estimates', function(Blueprint $table) {
			$table->foreign('agreementEstimateId')->references('id')->on('estimates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estimates', function(Blueprint $table) {
			$table->foreign('serviceItemId')->references('id')->on('service_items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('estimates', function(Blueprint $table) {
			$table->foreign('discountId')->references('id')->on('discounts')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_programId_foreign');
		});
		Schema::table('services_providers', function(Blueprint $table) {
			$table->dropForeign('services_providers_serviceId_foreign');
		});
		Schema::table('services_providers', function(Blueprint $table) {
			$table->dropForeign('services_providers_userId_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_customerId_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_serviceId_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_userId_foreign');
		});
		Schema::table('agreements', function(Blueprint $table) {
			$table->dropForeign('agreements_scopeFileId_foreign');
		});
		Schema::table('service_items', function(Blueprint $table) {
			$table->dropForeign('service_items_serviceId_foreign');
		});
		Schema::table('agreement_estimates', function(Blueprint $table) {
			$table->dropForeign('agreement_estimates_agreementId_foreign');
		});
		Schema::table('estimates', function(Blueprint $table) {
			$table->dropForeign('estimates_agreementEstimateId_foreign');
		});
		Schema::table('estimates', function(Blueprint $table) {
			$table->dropForeign('estimates_serviceItemId_foreign');
		});
		Schema::table('estimates', function(Blueprint $table) {
			$table->dropForeign('estimates_discountId_foreign');
		});
	}
}