<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParentTable extends Migration {

	public function up()
	{
		Schema::create('parent', function(Blueprint $table) {
			$table->increments('id');
			$table->string('parent', 100);
			$table->string('mother', 100)->nullable();
			$table->string('phoneno', 20)->unique();
			$table->string('email', 50);
			$table->integer('created_by')->unsigned();
			$table->timestamps();
			$table->integer('updated_by')->unsigned();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('parent');
	}
}