<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LigneCommande extends Eloquent {

	protected $table = 'ligne_commande';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id', 'commande_id', 'produit_id', 'quantiter_produit', 'prix_unitaire');

	public function relationCommandes()
	{
		return $this->belongsTo('App\Models\Commande');
	}

	public function relationProduit()
	{
		return $this->belongsTo('App\Models\Produit');
	}

}