<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Produit extends Eloquent {

	protected $table = 'produits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nom_produits', 'prix_produit', 'description_produit', 'categorie_id', 'image_produit', 'quantiter_stock');

	public function relationCategorie()
	{
		return $this->belongsTo('App\Models\Categorie');
	}

	public function relationLigneCommandes()
	{
		return $this->hasMany('App\Models\LigneCommande');
	}

}