<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellersTable extends Migration {

	public function up()
	{
		Schema::create('sellers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('promo_code');
			$table->string('user_name');
			$table->string('name')->nullable();
			$table->string('phone');
			$table->string('email');
			$table->string('f_b_page')->nullable();
			$table->enum('status', array('pending', 'rejected', 'active', 'deactivate', 'block'));
			$table->string('password');
			$table->string('pin_code')->nullable();
			$table->datetime('pin_code_date_expired')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sellers');
	}
}