<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('delivery_id')->nullable();
			$table->integer('start_address_id')->nullable();
			$table->integer('end_address_id');
			$table->string('phone')->nullable();
			$table->tinyInteger('pay_advance')->default('0');
			$table->enum('status', array('pending', 'accepted', 'rejected', 'delivered', 'canceled'));
			$table->float('price');
			$table->float('offer_price')->nullable();
			$table->float('delivery_cost')->nullable();
			$table->float('total_price');
			$table->datetime('schedule_date');
			$table->tinyInteger('is_published')->default('0');
			$table->text('note')->nullable();
			$table->text('reason')->nullable();
			$table->string('orderable_type');
			$table->integer('orderable_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}