<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClaimsTable extends Migration {

	public function up()
	{
		Schema::create('claims', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('amount');
			$table->integer('user_id')->unsigned();
			$table->integer('admin_id')->unsigned();
			$table->timestamp('claimed_at')->nullable();
			$table->timestamp('canceled_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('claims');
	}
}