<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('mobile_phone');
			$table->string('email');
			$table->longText('message');
			$table->boolean('is_read')->default(false);
			$table->boolean('is_active');
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}