<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReferenceEntitiesTable extends Migration {

	public function up()
	{
		Schema::create('reference_entities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('class')->nullable();
			$table->string('slug')->unique();
			$table->string('name')->unique();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reference_entities');
	}
}