<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Seller extends Model 
{

    protected $table = 'sellers';
    public $timestamps = true;
    protected $fillable = array('shop_name', 'district_id', 'email', 'min_charge', 'delivery_cost', 'mobile', 'whatsapp', 'image');
    protected $hidden = array('password');

    public function product()
    {
        return $this->hasMany('App\Product');
    }

    public function offer()
    {
        return $this->hasMany('App\Offer');
    }

    public function district()
    {
        return $this->hasOne('App\District');
    }

    public function category()
    {
        return $this->hasMany('App\Category');
    }

    public function review()
    {
        return $this->hasMany('App\Review');
    }

    public function order()
    {
        return $this->hasMany('App\Order');
    }

    public function notifiable()
    {
        return $this->morphMany('App\Notifcation');
    }

}