<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->bigInteger('type')->default('0');
			$table->decimal('monthly_fees', 10,2)->default('0');
			$table->decimal('quarterly_fees', 10,2)->default('0');
			$table->decimal('yearly_fees', 10,2)->default('0');
			$table->decimal('gym_fees', 10,2)->default('0');
			$table->decimal('bronze_fees', 10,2)->default('0');
			$table->decimal('silver_fees', 10,2)->default('0');
			$table->decimal('gold_fees', 10,2)->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}