<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('MemberInfo', function(Blueprint $table) {
			$table->foreign('MemberHouseholdID')->references('MemberID')->on('MemberInfo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberInfo', function(Blueprint $table) {
			$table->foreign('MemberTypeID')->references('InterestType')->on('InterestTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberInterest', function(Blueprint $table) {
			$table->foreign('MemberID')->references('MemberID')->on('MemberInfo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberInterest', function(Blueprint $table) {
			$table->foreign('InterestID')->references('MemberID')->on('MemberInfo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberAccountTransaction', function(Blueprint $table) {
			$table->foreign('MemberID')->references('MemberID')->on('MemberInfo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberAccountTransaction', function(Blueprint $table) {
			$table->foreign('TransactionTypeID')->references('MemberID')->on('MemberAccountTransaction')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Event', function(Blueprint $table) {
			$table->foreign('EventTypeID')->references('EventTypeID')->on('EventType')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Event', function(Blueprint $table) {
			$table->foreign('EventLeadID')->references('EventLeadID')->on('EventLead')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Event', function(Blueprint $table) {
			$table->foreign('EventLocationID')->references('LocationID')->on('Location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberEvent', function(Blueprint $table) {
			$table->foreign('MemberID')->references('MemberID')->on('MemberInfo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberEvent', function(Blueprint $table) {
			$table->foreign('MemberEventType')->references('EventTypeID')->on('EventType')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MemberEvent', function(Blueprint $table) {
			$table->foreign('MemberEventID')->references('EventID')->on('Event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PrvLoginSecret', function(Blueprint $table) {
			$table->foreign('MemberID')->references('MemberID')->on('MemberInfo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('MemberInfo', function(Blueprint $table) {
			$table->dropForeign('MemberInfo_MemberHouseholdID_foreign');
		});
		Schema::table('MemberInfo', function(Blueprint $table) {
			$table->dropForeign('MemberInfo_MemberTypeID_foreign');
		});
		Schema::table('MemberInterest', function(Blueprint $table) {
			$table->dropForeign('MemberInterest_MemberID_foreign');
		});
		Schema::table('MemberInterest', function(Blueprint $table) {
			$table->dropForeign('MemberInterest_InterestID_foreign');
		});
		Schema::table('MemberAccountTransaction', function(Blueprint $table) {
			$table->dropForeign('MemberAccountTransaction_MemberID_foreign');
		});
		Schema::table('MemberAccountTransaction', function(Blueprint $table) {
			$table->dropForeign('MemberAccountTransaction_TransactionTypeID_foreign');
		});
		Schema::table('Event', function(Blueprint $table) {
			$table->dropForeign('Event_EventTypeID_foreign');
		});
		Schema::table('Event', function(Blueprint $table) {
			$table->dropForeign('Event_EventLeadID_foreign');
		});
		Schema::table('Event', function(Blueprint $table) {
			$table->dropForeign('Event_EventLocationID_foreign');
		});
		Schema::table('MemberEvent', function(Blueprint $table) {
			$table->dropForeign('MemberEvent_MemberID_foreign');
		});
		Schema::table('MemberEvent', function(Blueprint $table) {
			$table->dropForeign('MemberEvent_MemberEventType_foreign');
		});
		Schema::table('MemberEvent', function(Blueprint $table) {
			$table->dropForeign('MemberEvent_MemberEventID_foreign');
		});
		Schema::table('PrvLoginSecret', function(Blueprint $table) {
			$table->dropForeign('PrvLoginSecret_MemberID_foreign');
		});
	}
}