<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100)->unique();
			$table->string('slug', 100)->unique();
			$table->text('image');
			$table->integer('parentid');
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('category');
	}
}