<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('blog_id', 'name', 'user_id');

    public function blog()
    {
        return $this->belongsTo('Blog', 'blog_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}