<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'post';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'details', 'category_id', 'blog_id', 'user_id', 'meta_title', 'meta_description');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function blog()
    {
        return $this->belongsTo('Blog', 'blog_id');
    }

    public function tags()
    {
        return $this->belongsToMany('Tag', 'post_id', 'tag_id', 'post_tag');
    }

}