<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostTag extends Model 
{

    protected $table = 'post_tag';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('post_id', 'tag_id');

    public function post()
    {
        return $this->belongsTo('Post', 'post_id');
    }

    public function tag()
    {
        return $this->belongsTo('Tag', 'tag_id');
    }

}