<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tag extends Model 
{

    protected $table = 'tag';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'is_private', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}