<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Block extends Eloquent {

	protected $table = 'block';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'title', 'content');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}