<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Shortcut extends Eloquent {

	protected $table = 'shortcut';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'link', 'user_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}