<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tag extends Eloquent {

	protected $table = 'tag';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'is_private', 'user_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}