<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlatformTable extends Migration {

	public function up()
	{
		Schema::create('platform', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->text('website')->nullable();
			$table->string('title')->nullable();
			$table->boolean('is_social')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('platform');
	}
}