<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesJobsTable extends Migration {

	public function up()
	{
		Schema::create('employees_jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('start')->index();
			$table->date('end')->index();
			$table->float('salary_gross');
			$table->float('base_hour');
			$table->boolean('handicap')->default(0);
			$table->boolean('regrading')->default(0);
			$table->integer('work_hardness')->index();
			$table->boolean('quiet_days')->index()->default(0);
			$table->bigInteger('employee_id')->unsigned();
			$table->bigInteger('business_branches_id')->unsigned()->nullable();
			$table->bigInteger('business_job_id')->unsigned()->nullable();
			$table->smallInteger('professional_class_id')->index();
			$table->smallInteger('contract_id')->index();
			$table->string('position', 5)->nullable()->index();
			$table->integer('coefficient')->index();
			$table->bigInteger('ending_argument_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('employees_jobs');
	}
}