<?php

namespace App\Models;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	public function jobs()
	{
		return $this->hasMany('EmployeesJobs', 'employee_id');
	}

	public function formations()
	{
		return $this->hasMany('EmployeesFormations', 'employee_id');
	}

	public function absenteeisms()
	{
		return $this->hasMany('EmployeesAbsenteeisms', 'employee_id');
	}

	public function conflicts()
	{
		return $this->hasMany('EmployeesConflicts', 'employee_id');
	}

	public function company()
	{
		return $this->belongsTo('Company');
	}

}