<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacilityDistancesTable extends Migration {

	public function up()
	{
		Schema::create('facility_distances', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('distance');
			$table->morphs('distanciable');
			$table->integer('lookup_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('facility_distances');
	}
}