<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('package_id')->unsigned();
			$table->enum('status', array('approved', 'rejected', 'active', 'inactive'));
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('amount');
			$table->integer('number_of_months');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}