<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Book extends Eloquent {

	protected $table = 'books';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function teachingMeterial()
	{
		return $this->belongsTo('App\Models\TeachingMeterial');
	}

	public function sections()
	{
		return $this->hasMany('App\Models\Section');
	}

	public function units()
	{
		return $this->hasMany('App\Models\Unit');
	}

}