<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class School extends Eloquent {

	protected $table = 'schools';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function grades()
	{
		return $this->hasMany('App\Models\Grade');
	}

	public function teachers()
	{
		return $this->hasMany('App\Models\Teacher');
	}

}