<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Teacher extends Eloquent {

	protected $table = 'teachers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function grades()
	{
		return $this->belongsToMany('App\Models\Grade');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

}