<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sources()
	{
		return $this->belongsToMany('App\Models\Resource');
	}

	public function messages()
	{
		return $this->hasMany('App\Models\Message');
	}

}